/*
 * Decompiled with CFR 0.152.
 */
package net.sf.flowcyt.gp.modules.deidentifyfcs;

public class ByteStringBuffer {
    private static int DEFAULT_SIZE = 256;
    private int initialSize = DEFAULT_SIZE;
    private byte[] buffer = null;
    private int pos = 0;
    private int parCounter = 1;

    public ByteStringBuffer(int initialSize) {
        this.initialSize = initialSize;
        this.buffer = new byte[this.initialSize];
        this.pos = 0;
    }

    public ByteStringBuffer() {
        this.initialSize = DEFAULT_SIZE;
        this.buffer = new byte[this.initialSize];
        this.pos = 0;
    }

    public void reset() {
        this.pos = 0;
    }

    public void add(byte b) {
        if (this.pos < this.buffer.length) {
            this.buffer[this.pos] = b;
            ++this.pos;
        } else {
            byte[] tmp = new byte[this.buffer.length + this.initialSize];
            int i = 0;
            while (i < this.pos) {
                tmp[i] = this.buffer[i];
                ++i;
            }
            this.buffer = tmp;
            this.buffer[this.pos] = b;
            ++this.pos;
        }
    }

    public String toString() {
        String ret = "";
        int i = 0;
        while (i < this.pos) {
            ret = String.valueOf(ret) + (char)this.buffer[i];
            ++i;
        }
        return ret;
    }

    public byte[] getBytes() {
        byte[] ret = new byte[this.pos];
        int i = 0;
        while (i < this.pos) {
            ret[i] = this.buffer[i];
            ++i;
        }
        return ret;
    }

    public byte[] getEmptyBytes() {
        byte[] ret = new byte[this.pos];
        int i = 0;
        while (i < this.pos) {
            ret[i] = 32;
            ++i;
        }
        return ret;
    }

    public byte[] getUniqueBytes() {
        String sValue = "P" + Integer.toString(this.parCounter++);
        int sValueLength = sValue.getBytes().length;
        byte[] ret = new byte[this.pos];
        int i = 0;
        while (i < this.pos) {
            ret[i] = i < sValueLength ? sValue.getBytes()[i] : 32;
            ++i;
        }
        return ret;
    }

    public byte[] getSpecifiedValueBytes(int nValue) {
        String sValue = Integer.toString(nValue);
        int sValueLength = sValue.getBytes().length;
        byte[] ret = new byte[this.pos];
        int i = 0;
        while (i < this.pos) {
            ret[i] = i < sValueLength ? sValue.getBytes()[i] : 32;
            ++i;
        }
        return ret;
    }
}

