/*
 * Decompiled with CFR 0.152.
 */
package net.sf.flowcyt.gp.modules.deidentifyfcs;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import javax.naming.ConfigurationException;
import net.sf.flowcyt.gp.modules.deidentifyfcs.IO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Config {
    private String inputFileName = "";
    private String outputFileName = "";
    private String removeKeywordsMatch = "";
    private Boolean regExprUsed = false;
    private Boolean versionRequest = false;
    private Boolean helpRequest = false;
    private Boolean fixDataSegmentsOffsets = false;

    public Config(String[] args) throws ConfigurationException {
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            String[] prefAndValue = arg.split(":", 2);
            if (prefAndValue != null && prefAndValue.length >= 1 && prefAndValue[0] != null) {
                CommandlineSwitch sw = Config.commandlineSwitchFromString(prefAndValue[0]);
                switch (sw) {
                    case InputFile: {
                        this.setInputFileName(prefAndValue[1]);
                        break;
                    }
                    case OutputFile: {
                        this.setOutputFileName(prefAndValue[1]);
                        break;
                    }
                    case Remove: {
                        this.setRemove(prefAndValue[1]);
                        break;
                    }
                    case IsRegExUsed: {
                        this.setRegExprUsed(prefAndValue[1]);
                        break;
                    }
                    case Debug: {
                        IO.setDebug(true);
                        break;
                    }
                    case Version: {
                        this.setVersionRequest(true);
                        break;
                    }
                    case Help: {
                        this.setHelpRequest(true);
                        break;
                    }
                    case FixDataSegmentsOffsets: {
                        this.setFixDataSegmentsOffsets(true);
                        break;
                    }
                    default: {
                        IO.debug("Unknown command line switch (" + prefAndValue[0] + ").");
                    }
                }
            }
            ++n2;
        }
        if ((this.outputFileName == null || this.outputFileName.length() == 0) && this.inputFileName != null && this.inputFileName.length() > 0) {
            int lastDotPos = this.inputFileName.lastIndexOf(46);
            this.outputFileName = lastDotPos != -1 ? String.valueOf(this.inputFileName.substring(0, lastDotPos)) + ".deidentified.fcs" : String.valueOf(this.inputFileName) + ".deidentified.fcs";
        }
        IO.debug("Commandline arguments parsed");
        this.validate();
    }

    private void validate() throws ConfigurationException {
        IO.debug("Argument validation:");
        if (this.getHelpRequest().booleanValue() || this.getVersionRequest().booleanValue()) {
            IO.debug("No need for validation; no conversion will be done, just printing some information...");
            return;
        }
        if (this.inputFileName == null || this.inputFileName.length() == 0) {
            throw new ConfigurationException("Missing input file name.");
        }
        IO.debug("-Input file name: " + this.inputFileName);
        if (this.outputFileName == null || this.outputFileName.length() == 0) {
            throw new ConfigurationException("Missing output file name base.");
        }
        IO.debug("-Output file name: " + this.outputFileName);
        if (this.removeKeywordsMatch == null || this.removeKeywordsMatch.length() == 0) {
            throw new ConfigurationException("Missing list or regular expression to match keywords to be removed.");
        }
        if (this.regExprUsed.booleanValue()) {
            IO.debug("-Keywords to be removed (regular expression): " + this.removeKeywordsMatch);
        } else {
            IO.debug("-Keywords to be removed (comma-separated list): " + this.removeKeywordsMatch);
        }
        IO.debug("Argument validation completed sucessfully");
    }

    private static CommandlineSwitch commandlineSwitchFromString(String command) {
        CommandlineSwitch ret = CommandlineSwitch.Unknown;
        if (command == null) {
            return ret;
        }
        if (command.equalsIgnoreCase("-InputFile")) {
            ret = CommandlineSwitch.InputFile;
        } else if (command.equalsIgnoreCase("-OutputFile")) {
            ret = CommandlineSwitch.OutputFile;
        } else if (command.equalsIgnoreCase("-Remove")) {
            ret = CommandlineSwitch.Remove;
        } else if (command.equalsIgnoreCase("-IsRegExUsed")) {
            ret = CommandlineSwitch.IsRegExUsed;
        } else if (command.equalsIgnoreCase("-Debug")) {
            ret = CommandlineSwitch.Debug;
        } else if (command.equalsIgnoreCase("-Version")) {
            ret = CommandlineSwitch.Version;
        } else if (command.equalsIgnoreCase("-Help")) {
            ret = CommandlineSwitch.Help;
        } else if (command.equalsIgnoreCase("-FixDataSegmentsOffsets")) {
            ret = CommandlineSwitch.FixDataSegmentsOffsets;
        }
        return ret;
    }

    public String getInputFileName() {
        return this.inputFileName;
    }

    public File getInputFile() {
        return new File(this.getInputFileName());
    }

    public InputStream getInputStream() throws FileNotFoundException {
        return new BufferedInputStream(new FileInputStream(this.getInputFileName()));
    }

    public OutputStream getOutputStream() throws FileNotFoundException {
        return new BufferedOutputStream(new FileOutputStream(this.getOutputFileName()));
    }

    private void setInputFileName(String inputFileName) {
        if (inputFileName != null) {
            this.inputFileName = inputFileName;
        }
    }

    public String getOutputFileName() {
        return this.outputFileName;
    }

    private void setOutputFileName(String outputFileNameBase) {
        if (outputFileNameBase != null) {
            this.outputFileName = outputFileNameBase;
        }
    }

    public String getRemove() {
        return this.removeKeywordsMatch;
    }

    private void setRemove(String removeKeywordsMatch) {
        this.removeKeywordsMatch = removeKeywordsMatch;
    }

    public Boolean isRegExprUsed() {
        return this.regExprUsed;
    }

    private void setRegExprUsed(String regExprUsed) {
        this.regExprUsed = regExprUsed.compareToIgnoreCase("Yes") == 0 || regExprUsed.compareToIgnoreCase("Y") == 0 ? Boolean.valueOf(true) : Boolean.valueOf(false);
    }

    public Boolean getVersionRequest() {
        return this.versionRequest;
    }

    private void setVersionRequest(Boolean versionRequest) {
        this.versionRequest = versionRequest;
    }

    public Boolean getFixDataSegmentsOffsets() {
        return this.fixDataSegmentsOffsets;
    }

    private void setFixDataSegmentsOffsets(Boolean fixDataSegmentsOffsets) {
        this.fixDataSegmentsOffsets = fixDataSegmentsOffsets;
    }

    public Boolean getHelpRequest() {
        return this.helpRequest;
    }

    private void setHelpRequest(Boolean helpRequest) {
        this.helpRequest = helpRequest;
    }

    public HashMap<String, Boolean> getKeywordsToRemoveMap() {
        if (this.regExprUsed.booleanValue()) {
            return null;
        }
        HashMap<String, Boolean> ret = new HashMap<String, Boolean>();
        String[] keywordsToRemove = this.removeKeywordsMatch.split(",");
        int i = 0;
        while (i < keywordsToRemove.length) {
            int j = 1;
            while (keywordsToRemove[i] != null && keywordsToRemove[i].length() > 0 && keywordsToRemove[i].charAt(keywordsToRemove[i].length() - 1) == '\\') {
                if (i + j >= keywordsToRemove.length) break;
                keywordsToRemove[i] = String.valueOf(keywordsToRemove[i].substring(0, keywordsToRemove[i].length() - 1)) + "," + keywordsToRemove[i + j];
                keywordsToRemove[i + j] = "";
                ++j;
            }
            keywordsToRemove[i] = keywordsToRemove[i].trim();
            ++i;
        }
        i = 0;
        while (i < keywordsToRemove.length) {
            if (keywordsToRemove[i].length() > 0) {
                ret.put(keywordsToRemove[i], false);
            }
            ++i;
        }
        return ret;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CommandlineSwitch {
        InputFile,
        OutputFile,
        Remove,
        IsRegExUsed,
        Debug,
        Version,
        Help,
        Unknown,
        FixDataSegmentsOffsets;

    }
}

