/*
 * Decompiled with CFR 0.152.
 */
package net.sf.flowcyt.gp.modules.deidentifyfcs;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.ConfigurationException;
import net.sf.flowcyt.gp.modules.deidentifyfcs.ByteStringBuffer;
import net.sf.flowcyt.gp.modules.deidentifyfcs.Config;
import net.sf.flowcyt.gp.modules.deidentifyfcs.IO;

public class DeIdentifyFCS {
    private Config config;
    private InputStream in = null;
    private OutputStream out = null;
    private int textBeginOffset;
    private int textEndOffset;
    private int dataBeginOffset;
    private int dataEndOffset;
    private int analysisBeginOffset;
    private int analysisEndOffset;
    private int suplTextBeginOffset;
    private int suplTextEndOffset;
    private int nextData;
    private int textSegmentParsingState;
    private String fcsVersion;
    private String textBeginOffsetStr;
    private String textEndOffsetStr;
    private String dataBeginOffsetStr;
    private String dataEndOffsetStr;
    private String analysisBeginOffsetStr;
    private String analysisEndOffsetStr;
    private ByteStringBuffer textSegmentBuffer;
    private String lastKeywordName;
    private String lastKeywordValue;
    private String oneDelimiter;
    private String twoDelimiters;
    private int delimiterCharacter;
    private Pattern pattern = null;
    private HashMap<String, Boolean> keywordsToRemove = new HashMap();
    private Boolean regExpMatchFound = false;
    private static HashSet<String> systemKeywords = new HashSet();
    private static Boolean systemKeywordsHashSetCreated = false;
    public static final String version = "DeIdentifyFCS by Josef Spidlen, version beta 2014-05-05.";
    public static final String usage = "Usage:\njava -jar deidentifyfcs.jar <options> \n\noptions:\n\n -InputFile:<file.fcs>  The input FCS file, required unless -Version or -Help is used.\n -Remove:<list|regExpr> Comma-separated list of keyword names (comma as part of a keyword name may be escaped by '\\') or a regular expression to match keywords to be removed, required unless -Version or -Help is used.\n -IsRegExUsed:<Yes|No>  Is a regular expression used in the Remove tag? If not, a comma-separated list of keyword names is expected (optional)\n -OutputFile:<filename> The output file name (optional)\n -Debug                 Produces debug output.\n -Version               Output the version of the software and exit (no de-identification).\n -Help                  Output the command line syntax and exit (no de-identification).\n";

    public static void main(String[] args) {
        DeIdentifyFCS app = new DeIdentifyFCS();
        app.run(args);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void run(String[] args) {
        block70: {
            block69: {
                try {
                    block72: {
                        block71: {
                            this.config = new Config(args);
                            if (!this.config.getVersionRequest().booleanValue()) break block71;
                            IO.println("DeIdentifyFCS by Josef Spidlen, version beta 2014-05-05.");
                            ** GOTO lbl10
                        }
                        if (!this.config.getHelpRequest().booleanValue()) break block72;
                        IO.println("Usage:\njava -jar deidentifyfcs.jar <options> \n\noptions:\n\n -InputFile:<file.fcs>  The input FCS file, required unless -Version or -Help is used.\n -Remove:<list|regExpr> Comma-separated list of keyword names (comma as part of a keyword name may be escaped by '\\') or a regular expression to match keywords to be removed, required unless -Version or -Help is used.\n -IsRegExUsed:<Yes|No>  Is a regular expression used in the Remove tag? If not, a comma-separated list of keyword names is expected (optional)\n -OutputFile:<filename> The output file name (optional)\n -Debug                 Produces debug output.\n -Version               Output the version of the software and exit (no de-identification).\n -Help                  Output the command line syntax and exit (no de-identification).\n");
lbl10:
                        // 2 sources

                        try {
                            if (this.in != null) {
                                this.in.close();
                            }
                        }
                        catch (Exception var8_2) {
                            // empty catch block
                        }
                        try {
                            if (this.out == null) return;
                            this.out.flush();
                            this.out.close();
                            return;
                        }
                        catch (Exception var8_3) {
                            // empty catch block
                        }
                        return;
                    }
                    IO.debug("-------------------\nDe-identification started");
                    if (this.config.isRegExprUsed().booleanValue()) {
                        this.pattern = Pattern.compile(this.config.getRemove());
                    } else {
                        this.keywordsToRemove = this.config.getKeywordsToRemoveMap();
                    }
                    this.in = this.config.getInputStream();
                    this.out = this.config.getOutputStream();
                    offset = 0;
                    while (true) {
                        if ((c = this.in.read()) == -1) {
                            IO.debug("-------------------\nDe-identification finished");
                            if (!this.config.isRegExprUsed().booleanValue()) break;
                            if (!this.regExpMatchFound.booleanValue()) {
                                IO.println("Warning - regular expression did not match any keywords in this FCS file");
                            }
                            break block69;
                        }
                        if (this.isWithinHeader(offset).booleanValue()) {
                            this.parseHeaderChar(offset, c);
                        } else if (this.isWithinTextSegment(offset).booleanValue()) {
                            this.parseTextChar(offset, c);
                        } else if (this.isNextDataSet(offset).booleanValue()) {
                            IO.debug("-------------------\nFound another dataset in the FCS file, processing...");
                            offset = 0;
                            this.parseHeaderChar(offset, c);
                        } else {
                            this.out.write(this.textSegmentBuffer.getBytes());
                            this.textSegmentBuffer.reset();
                            this.out.write(c);
                        }
                        ++offset;
                    }
                    if (!this.keywordsToRemove.containsValue(false)) break block69;
                    s = "";
                    var6_26 = this.keywordsToRemove.keySet().iterator();
                    while (true) {
                        if (!var6_26.hasNext()) {
                            IO.println("Warning - the following keywords were supposed to be removed but could not be found in this FCS file: " + s);
                            break;
                        }
                        keyword = var6_26.next();
                        if (this.keywordsToRemove.get(keyword).booleanValue()) continue;
                        if (s.length() > 0) {
                            s = String.valueOf(s) + ", \"" + keyword + "\"";
                            continue;
                        }
                        s = String.valueOf(s) + "\"" + keyword + "\"";
                    }
                }
                catch (ConfigurationException e) {
                    IO.error("Configuration Error: " + e.getMessage());
                    IO.println("\nUsage:\njava -jar deidentifyfcs.jar <options> \n\noptions:\n\n -InputFile:<file.fcs>  The input FCS file, required unless -Version or -Help is used.\n -Remove:<list|regExpr> Comma-separated list of keyword names (comma as part of a keyword name may be escaped by '\\') or a regular expression to match keywords to be removed, required unless -Version or -Help is used.\n -IsRegExUsed:<Yes|No>  Is a regular expression used in the Remove tag? If not, a comma-separated list of keyword names is expected (optional)\n -OutputFile:<filename> The output file name (optional)\n -Debug                 Produces debug output.\n -Version               Output the version of the software and exit (no de-identification).\n -Help                  Output the command line syntax and exit (no de-identification).\n");
                    try {
                        if (this.in != null) {
                            this.in.close();
                        }
                    }
                    catch (Exception var8_4) {
                        // empty catch block
                    }
                    try {
                        if (this.out != null) {
                            this.out.flush();
                            this.out.close();
                        }
                        break block70;
                    }
                    catch (Exception var8_5) {}
                    break block70;
                }
                catch (FileNotFoundException fnf) {
                    IO.error("File not found: " + fnf.getMessage());
                    break block70;
                    catch (IOException ioe) {
                        IO.error("IO Exception: " + ioe.getMessage());
                        {
                            catch (Throwable var7_28) {
                                throw var7_28;
                            }
                        }
                        try {
                            if (this.in != null) {
                                this.in.close();
                            }
                        }
                        catch (Exception var8_8) {
                            // empty catch block
                        }
                        try {
                            if (this.out != null) {
                                this.out.flush();
                                this.out.close();
                            }
                            break block70;
                        }
                        catch (Exception var8_9) {}
                        break block70;
                        catch (NumberFormatException nfe) {
                            IO.error("Input offsets seem broken - NumberFormatException: " + nfe.getMessage());
                            try {
                                if (this.in != null) {
                                    this.in.close();
                                }
                            }
                            catch (Exception var8_10) {
                                // empty catch block
                            }
                            try {
                                if (this.out != null) {
                                    this.out.flush();
                                    this.out.close();
                                }
                                break block70;
                            }
                            catch (Exception var8_11) {}
                            break block70;
                        }
                    }
                    finally {
                        try {
                            if (this.in != null) {
                                this.in.close();
                            }
                        }
                        catch (Exception var8_6) {}
                        try {
                            if (this.out != null) {
                                this.out.flush();
                                this.out.close();
                            }
                        }
                        catch (Exception var8_7) {}
                    }
                }
            }
            try {
                if (this.in != null) {
                    this.in.close();
                }
            }
            catch (Exception var8_14) {
                // empty catch block
            }
            try {
                if (this.out != null) {
                    this.out.flush();
                    this.out.close();
                }
            }
            catch (Exception var8_15) {
                // empty catch block
            }
        }
        try {
            f1 = new File(this.config.getInputFileName());
            f2 = new File(this.config.getOutputFileName());
            if (f1.length() == f2.length()) return;
            IO.error("File sizes do not match, the de-identification must have failed.");
            return;
        }
        catch (Exception e) {
            IO.error("The de-identification failed.");
        }
    }

    private void resetForNewDataset() {
        this.textBeginOffset = 0;
        this.textEndOffset = 0;
        this.dataBeginOffset = 0;
        this.dataEndOffset = 0;
        this.analysisBeginOffset = 0;
        this.analysisEndOffset = 0;
        this.suplTextBeginOffset = 0;
        this.suplTextEndOffset = 0;
        this.nextData = 0;
        this.textSegmentParsingState = 0;
        this.fcsVersion = "";
        this.textSegmentBuffer = new ByteStringBuffer();
        this.lastKeywordName = "";
        this.lastKeywordValue = "";
        this.textBeginOffsetStr = "";
        this.textEndOffsetStr = "";
        this.dataBeginOffsetStr = "";
        this.dataEndOffsetStr = "";
        this.analysisBeginOffsetStr = "";
        this.analysisEndOffsetStr = "";
        this.delimiterCharacter = -1;
        this.oneDelimiter = "";
        this.twoDelimiters = "";
    }

    private Boolean isWithinHeader(int offset) {
        if (offset <= 57) {
            return true;
        }
        return false;
    }

    private Boolean isWithinTextSegment(int offset) {
        if (offset >= this.textBeginOffset && offset <= this.textEndOffset) {
            return true;
        }
        if (offset >= this.suplTextBeginOffset && offset <= this.suplTextEndOffset) {
            return true;
        }
        return false;
    }

    private Boolean isNextDataSet(int offset) {
        if (offset == this.nextData) {
            return true;
        }
        return false;
    }

    private void parseTextChar(int offset, int c) throws IOException, ConfigurationException {
        if (offset == this.textBeginOffset || offset == this.suplTextBeginOffset) {
            this.textSegmentBuffer.reset();
            this.delimiterCharacter = c;
            this.twoDelimiters = "";
            this.twoDelimiters = String.valueOf(this.twoDelimiters) + (char)this.delimiterCharacter;
            this.twoDelimiters = String.valueOf(this.twoDelimiters) + (char)this.delimiterCharacter;
            this.oneDelimiter = "";
            this.oneDelimiter = String.valueOf(this.oneDelimiter) + (char)this.delimiterCharacter;
            IO.debug("Detected TEXT segment delimiter character: \"" + (char)c + "\"");
            this.out.write(c);
            this.textSegmentParsingState = 1;
        } else {
            switch (this.textSegmentParsingState) {
                case 0: {
                    throw new ConfigurationException("Something went wrong, trying to parse the TEXT segment without knowing the delimiter character. Please submit a but report to the author.");
                }
                case 1: {
                    if (c == this.delimiterCharacter) {
                        this.textSegmentParsingState = 2;
                        break;
                    }
                    this.textSegmentBuffer.add((byte)c);
                    break;
                }
                case 2: {
                    if (c == this.delimiterCharacter) {
                        this.textSegmentBuffer.add((byte)c);
                        this.textSegmentBuffer.add((byte)c);
                        this.textSegmentParsingState = 1;
                        break;
                    }
                    this.out.write(this.textSegmentBuffer.getBytes());
                    this.lastKeywordName = this.ConvertTwoDelimitersToOne(this.textSegmentBuffer.toString());
                    this.textSegmentBuffer.reset();
                    this.textSegmentBuffer.add((byte)c);
                    this.out.write(this.delimiterCharacter);
                    this.textSegmentParsingState = 3;
                    break;
                }
                case 3: {
                    if (c == this.delimiterCharacter) {
                        this.textSegmentParsingState = 4;
                    } else {
                        this.textSegmentBuffer.add((byte)c);
                    }
                    if (offset != this.textEndOffset && offset != this.suplTextEndOffset) break;
                    this.lastKeywordValue = this.ConvertTwoDelimitersToOne(this.textSegmentBuffer.toString());
                    this.checkKeyWordAndWriteValueEventually(this.lastKeywordName, this.lastKeywordValue, this.textSegmentBuffer);
                    this.textSegmentBuffer.reset();
                    this.out.write(this.delimiterCharacter);
                    this.textSegmentParsingState = 1;
                    break;
                }
                case 4: {
                    if (c == this.delimiterCharacter && offset != this.textEndOffset && offset != this.suplTextEndOffset) {
                        this.textSegmentBuffer.add((byte)c);
                        this.textSegmentBuffer.add((byte)c);
                        this.textSegmentParsingState = 3;
                        break;
                    }
                    this.lastKeywordValue = this.ConvertTwoDelimitersToOne(this.textSegmentBuffer.toString());
                    this.checkKeyWordAndWriteValueEventually(this.lastKeywordName, this.lastKeywordValue, this.textSegmentBuffer);
                    this.textSegmentBuffer.reset();
                    this.textSegmentBuffer.add((byte)c);
                    this.out.write(this.delimiterCharacter);
                    if (offset == this.textEndOffset || offset == this.suplTextEndOffset) {
                        this.out.write(this.textSegmentBuffer.getBytes());
                        this.textSegmentBuffer.reset();
                    }
                    this.textSegmentParsingState = 1;
                }
            }
        }
    }

    private void checkKeyWordAndWriteValueEventually(String kwName, String kwValue, ByteStringBuffer buffer) throws IOException {
        if (this.keepKeyword(kwName)) {
            IO.debug("+ Keeping keyword:  \"" + kwName + "\", value \"" + kwValue + "\"");
            this.out.write(buffer.getBytes());
        } else if (this.config.getFixDataSegmentsOffsets().booleanValue() && (kwName.compareTo("$BEGINDATA") == 0 || kwName.compareTo("$ENDDATA") == 0)) {
            int value = this.dataEndOffset;
            if (kwName.compareTo("$BEGINDATA") == 0) {
                value = this.dataBeginOffset;
            }
            IO.debug("# Fixing the value of keyword: \"" + kwName + "\" to \"" + value + "\"");
            this.out.write(buffer.getSpecifiedValueBytes(value));
        } else if (DeIdentifyFCS.isParameterNameSystemKeyword(kwName)) {
            IO.debug("- Removing keyword: \"" + kwName + "\", value \"" + kwValue + "\" replaced with a random unique string.");
            this.out.write(buffer.getUniqueBytes());
        } else {
            IO.debug("- Removing keyword: \"" + kwName + "\", value \"" + kwValue + "\"");
            this.out.write(buffer.getEmptyBytes());
            if (DeIdentifyFCS.isRequiredSystemKeyword(kwName)) {
                IO.println("---------- Warning: \"" + kwName + "\" was a required system keyword, the result may not be a valid FCS file");
            }
        }
        String s = kwValue.trim();
        if (s.length() > 0) {
            if (kwName.compareTo("$BEGINDATA") == 0 && !this.config.getFixDataSegmentsOffsets().booleanValue()) {
                this.dataBeginOffset = Integer.parseInt(s);
                IO.debug("Updated offset to the first byte of DATA segment:      " + this.dataBeginOffset);
            }
            if (kwName.compareTo("$ENDDATA") == 0 && !this.config.getFixDataSegmentsOffsets().booleanValue()) {
                this.dataEndOffset = Integer.parseInt(s);
                IO.debug("Updated offset to the last byte of DATA segment:       " + this.dataEndOffset);
            }
            if (kwName.compareTo("$BEGINANALYSIS") == 0) {
                this.analysisBeginOffset = Integer.parseInt(s);
                IO.debug("Updated offset to the first byte of ANALYSIS segment:  " + this.analysisBeginOffset);
            }
            if (kwName.compareTo("$ENDANALYSIS") == 0) {
                this.analysisEndOffset = Integer.parseInt(s);
                IO.debug("Updated offset to the last byte of ANALYSIS segment:   " + this.analysisEndOffset);
            }
            if (kwName.compareTo("$BEGINSTEXT") == 0) {
                this.suplTextBeginOffset = Integer.parseInt(s);
                IO.debug("Detected offset to the first byte of SUP.TEXT segment: " + this.suplTextBeginOffset);
            }
            if (kwName.compareTo("$ENDSTEXT") == 0) {
                this.suplTextEndOffset = Integer.parseInt(s);
                IO.debug("Detected offset to the last byte of SUP.TEXT segment:  " + this.suplTextEndOffset);
            }
            if (kwName.compareTo("$NEXTDATA") == 0) {
                this.nextData = Integer.parseInt(s);
                if (this.nextData > 0) {
                    IO.debug("Detected offset to the next dataset within this FCS:   " + this.nextData);
                } else {
                    IO.debug("Detected that thare are no additional datasets within this FCS");
                }
            }
        }
    }

    private String ConvertTwoDelimitersToOne(String input) {
        return input.replace(this.twoDelimiters, this.oneDelimiter);
    }

    private void parseHeaderChar(int offset, int c) throws IOException, ConfigurationException {
        if (offset == 0) {
            this.resetForNewDataset();
        }
        if (offset < 5) {
            this.fcsVersion = String.valueOf(this.fcsVersion) + (char)c;
        } else if (offset == 5) {
            this.fcsVersion = String.valueOf(this.fcsVersion) + (char)c;
            if (this.fcsVersion.substring(0, 3).compareTo("FCS") != 0) {
                throw new ConfigurationException("Input does not seem to be an FCS file, header says: " + this.fcsVersion);
            }
            IO.debug("Detected FCS version: " + this.fcsVersion);
            this.out.write(this.fcsVersion.getBytes());
        } else if (offset >= 10 && offset < 17) {
            this.textBeginOffsetStr = String.valueOf(this.textBeginOffsetStr) + (char)c;
            this.out.write(c);
        } else if (offset == 17) {
            this.textBeginOffsetStr = String.valueOf(this.textBeginOffsetStr) + (char)c;
            this.textBeginOffsetStr = this.textBeginOffsetStr.trim();
            if (this.textBeginOffsetStr.length() > 0) {
                this.textBeginOffset = Integer.parseInt(this.textBeginOffsetStr);
            }
            IO.debug("Detected offset to the first byte of TEXT segment:     " + this.textBeginOffset);
            this.out.write(c);
        } else if (offset >= 18 && offset < 25) {
            this.textEndOffsetStr = String.valueOf(this.textEndOffsetStr) + (char)c;
            this.out.write(c);
        } else if (offset == 25) {
            this.textEndOffsetStr = String.valueOf(this.textEndOffsetStr) + (char)c;
            this.textEndOffsetStr = this.textEndOffsetStr.trim();
            if (this.textEndOffsetStr.length() > 0) {
                this.textEndOffset = Integer.parseInt(this.textEndOffsetStr);
            }
            IO.debug("                  - and last byte of TEXT segment:     " + this.textEndOffset);
            this.out.write(c);
        } else if (offset >= 26 && offset < 33) {
            this.dataBeginOffsetStr = String.valueOf(this.dataBeginOffsetStr) + (char)c;
            this.out.write(c);
        } else if (offset == 33) {
            this.dataBeginOffsetStr = String.valueOf(this.dataBeginOffsetStr) + (char)c;
            this.dataBeginOffsetStr = this.dataBeginOffsetStr.trim();
            if (this.dataBeginOffsetStr.length() > 0) {
                this.dataBeginOffset = Integer.parseInt(this.dataBeginOffsetStr);
            }
            IO.debug("Detected offset to the first byte of DATA segment:     " + this.dataBeginOffset);
            this.out.write(c);
        } else if (offset >= 34 && offset < 41) {
            this.dataEndOffsetStr = String.valueOf(this.dataEndOffsetStr) + (char)c;
            this.out.write(c);
        } else if (offset == 41) {
            this.dataEndOffsetStr = String.valueOf(this.dataEndOffsetStr) + (char)c;
            this.dataEndOffsetStr = this.dataEndOffsetStr.trim();
            if (this.dataEndOffsetStr.length() > 0) {
                this.dataEndOffset = Integer.parseInt(this.dataEndOffsetStr);
            }
            IO.debug("                  - and last byte of DATA segment:     " + this.dataEndOffset);
            this.out.write(c);
        } else if (offset >= 42 && offset < 49) {
            this.analysisBeginOffsetStr = String.valueOf(this.analysisBeginOffsetStr) + (char)c;
            this.out.write(c);
        } else if (offset == 49) {
            this.analysisBeginOffsetStr = String.valueOf(this.analysisBeginOffsetStr) + (char)c;
            this.analysisBeginOffsetStr = this.analysisBeginOffsetStr.trim();
            if (this.analysisBeginOffsetStr.length() > 0) {
                this.analysisBeginOffset = Integer.parseInt(this.analysisBeginOffsetStr);
            }
            IO.debug("Detected offset to the first byte of ANALYSIS segment: " + this.analysisBeginOffset);
            this.out.write(c);
        } else if (offset >= 50 && offset < 57) {
            this.analysisEndOffsetStr = String.valueOf(this.analysisEndOffsetStr) + (char)c;
            this.out.write(c);
        } else if (offset == 57) {
            this.analysisEndOffsetStr = String.valueOf(this.analysisEndOffsetStr) + (char)c;
            this.analysisEndOffsetStr = this.analysisEndOffsetStr.trim();
            if (this.analysisEndOffsetStr.length() > 0) {
                this.analysisEndOffset = Integer.parseInt(this.analysisEndOffsetStr);
            }
            IO.debug("                  - and last byte of ANALYSIS segment: " + this.analysisEndOffset);
            this.out.write(c);
        } else {
            this.out.write(c);
        }
    }

    private boolean keepKeyword(String keyword) {
        if (this.config.isRegExprUsed().booleanValue()) {
            Matcher matcher = this.pattern.matcher(keyword);
            if (matcher.find()) {
                this.regExpMatchFound = true;
                return false;
            }
            return true;
        }
        if (this.keywordsToRemove.containsKey(keyword)) {
            this.keywordsToRemove.put(keyword, true);
            return false;
        }
        return true;
    }

    private static boolean isRequiredSystemKeyword(String keyword) {
        if (!systemKeywordsHashSetCreated.booleanValue()) {
            DeIdentifyFCS.fillInSystemKeywords();
        }
        if (systemKeywords.contains(keyword)) {
            return true;
        }
        return keyword.startsWith("$P") && (keyword.endsWith("B") || keyword.endsWith("E") || keyword.endsWith("N") || keyword.endsWith("R"));
    }

    private static boolean isParameterNameSystemKeyword(String keyword) {
        if (!systemKeywordsHashSetCreated.booleanValue()) {
            DeIdentifyFCS.fillInSystemKeywords();
        }
        return keyword.startsWith("$P") && keyword.endsWith("N");
    }

    private static void fillInSystemKeywords() {
        systemKeywords.add("$BEGINANALYSIS");
        systemKeywords.add("$BEGINDATA");
        systemKeywords.add("$BEGINSTEXT");
        systemKeywords.add("$BYTEORD");
        systemKeywords.add("$DATATYPE");
        systemKeywords.add("$ENDANALYSIS");
        systemKeywords.add("$ENDDATA");
        systemKeywords.add("$ENDSTEXT");
        systemKeywords.add("$MODE");
        systemKeywords.add("$NEXTDATA");
        systemKeywords.add("$PAR");
        systemKeywords.add("$TOT");
        systemKeywordsHashSetCreated = true;
    }
}

